        <?php
/**
 * Plugin Name: 自定义登录状态
 * Plugin URI:  
 * Description: 在网站顶部显示用户登录状态 - 未登录显示注册/登录，已登录显示用户名和个人中心链接
 * Version:     1.0
 * Author:      您的名称
 * License:     GPL v2 or later
 */

// 防止直接访问
if (!defined('ABSPATH')) {
    exit;
}

class CustomLoginStatus {
    
    public function __construct() {
        // 初始化插件
        add_action('init', array($this, 'init'));
    }
    
    public function init() {
        // 在网站头部添加登录状态显示
        add_action('wp_head', array($this, 'display_login_status'));
        
        // 加载CSS样式
        add_action('wp_enqueue_scripts', array($this, 'enqueue_styles'));
    }
    
    // 显示登录状态
    public function display_login_status() {
        // 只在网站前端显示，不在后台显示
        if (is_admin()) {
            return;
        }
        
        ob_start();
        ?>
        <div id="custom-login-status-bar">
            <div class="login-status-container">
                <?php if (is_user_logged_in()) : ?>
                    <?php 
                    $current_user = wp_get_current_user();
                    $profile_url = get_edit_profile_url($current_user->ID);
                    ?>
                    <span class="welcome-text">你好，</span>
                    <a href="<?php echo esc_url($profile_url); ?>" class="username">
                        <?php echo esc_html($current_user->display_name); ?>
                    </a>
                    <a href="<?php echo wp_logout_url(home_url()); ?>" class="logout-link">退出</a>
                <?php else : ?>
                    <a href="<?php echo wp_login_url(); ?>" class="login-link">登录</a>
                    <span class="separator">|</span>
                    <a href="<?php echo wp_registration_url(); ?>" class="register-link">注册</a>
                <?php endif; ?>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }
    
    // 加载CSS样式
    public function enqueue_styles() {
        $css = "
        #custom-login-status-bar {
            background: #f8f9fa;
            border-bottom: 1px solid #e9ecef;
            padding: 8px 0;
            font-size: 14px;
            line-height: 1.4;
            width: 100%;
            z-index: 9;
            position: relative;
        }
        
        .login-status-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            text-align: right;
        }
        
        #custom-login-status-bar a {
            text-decoration: none;
            color: #495057;
            margin: 0 5px;
            transition: color 0.3s ease;
        }
        
        #custom-login-status-bar a:hover {
            color: #007cba;
        }
        
        .welcome-text {
            color: #6c757d;
        }
        
        .username {
            font-weight: 500;
            color: #343a40;
        }
        
        .separator {
            color: #dee2e6;
            margin: 0 5px;
        }
        
        .login-link, .register-link {
            padding: 4px 8px;
            border-radius: 3px;
        }
        
        .login-link:hover, .register-link:hover {
            background: #e9ecef;
        }
        
        .logout-link {
            margin-left: 10px;
            padding: 4px 8px;
            background: #6c757d;
            color: white !important;
            border-radius: 3px;
            font-size: 12px;
        }
        
        .logout-link:hover {
            background: #5a6268;
        }
        
        /* 响应式设计 */
        @media (max-width: 768px) {
            .login-status-container {
                text-align: center;
                padding: 0 10px;
            }
            
            #custom-login-status-bar {
                font-size: 13px;
                padding: 6px 0;
            }
        }
        ";
        
        wp_add_inline_style('wp-block-library', $css);
    }
}

// 初始化插件
new CustomLoginStatus();

// 插件激活时的操作
register_activation_hook(__FILE__, 'custom_login_status_activate');
function custom_login_status_activate() {
    // 可以在这里添加激活时的初始化代码
}

// 插件停用时的操作  
register_deactivation_hook(__FILE__, 'custom_login_status_deactivate');
function custom_login_status_deactivate() {
    // 清理代码（如果需要）
}
?>