jQuery(document).ready(function($) {
    var mediaUploader;
    
    // 上传图片
    $('#easywp-upload-mobile-featured-image').click(function(e) {
        e.preventDefault();
        
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }
        
        mediaUploader = wp.media({
            title: easywp_mfi.title,
            button: {
                text: easywp_mfi.button
            },
            multiple: false
        });
        
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#easywp_mobile_featured_image_id').val(attachment.id);
            
            var imagePreview = $('.image-preview');
            if (imagePreview.length) {
                imagePreview.html('<img src="' + attachment.url + '" style="max-width: 100%; height: auto;" />');
            }
            
            $('#easywp-upload-mobile-featured-image').addClass('hidden');
            $('#easywp-remove-mobile-featured-image').removeClass('hidden');
        });
        
        mediaUploader.open();
    });
    
    // 移除图片
    $('#easywp-remove-mobile-featured-image').click(function(e) {
        e.preventDefault();
        
        $('#easywp_mobile_featured_image_id').val('');
        $('.image-preview').html('');
        
        $('#easywp-upload-mobile-featured-image').removeClass('hidden');
        $('#easywp-remove-mobile-featured-image').addClass('hidden');
    });
});