<?php
/**
 * Plugin Name: OneStep Register
 * Description: 原生注册页直接输密码、无邮件、注册即登录并跳首页
 * Version:     1.0
 * Author:      life8882
 * License:     GPL-2.0+
 */

// 阻止直接访问
if ( ! defined( 'ABSPATH' ) ) { exit; }

/* ---------- 1. 追加密码框 ---------- */
add_action( 'register_form', 'osr_add_password_fields' );
function osr_add_password_fields() {
    ?>
    <p>
        <label for="user_pass">密码<br>
        <input type="password" name="user_pass" id="user_pass" class="input" required autocomplete="new-password"></label>
    </p>
    <p>
        <label for="user_pass2">确认密码<br>
        <input type="password" name="user_pass2" id="user_pass2" class="input" required autocomplete="new-password"></label>
    </p>
    <?php
}

/* ---------- 2. 前端校验两次密码 ---------- */
add_action( 'login_head', 'osr_password_confirm_js' );
function osr_password_confirm_js() {
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function(){
        const f = document.getElementById('registerform');
        if( ! f ) return;
        f.onsubmit = function(){
            if( f.user_pass.value !== f.user_pass2.value ){
                alert('两次密码不一致！');
                return false;
            }
        };
    });
    </script>
    <?php
}

/* ---------- 3. 注册瞬间：直接写密码 + 关闭所有邮件 ---------- */
add_action( 'user_register', 'osr_set_password_and_nomail', 999 );
function osr_set_password_and_nomail( $user_id ) {
    if ( ! empty( $_POST['user_pass'] ) && $_POST['user_pass'] === $_POST['user_pass2'] ) {
        wp_set_password( $_POST['user_pass'], $user_id );
    }
    // 屏蔽所有重置/通知邮件
    add_filter( 'send_password_change_email',   '__return_false' );
    add_filter( 'retrieve_password_message',    '__return_empty_string' );
    add_filter( 'send_retrieve_password_email', '__return_false' );
    add_filter( 'wp_new_user_notification_email', '__return_false' );
}

/* ---------- 4. 替换“请查邮件”提示 ---------- */
add_filter( 'gettext', 'osr_replace_email_hints', 10, 3 );
function osr_replace_email_hints( $translation, $text, $domain ) {
    $needles = [ '注册完成', '注册确认', '检查您邮箱', 'check your email', 'registration confirmation' ];
    foreach ( $needles as $n ) {
        if ( stripos( $text, $n ) !== false ) {
            return '注册成功！请直接用刚才设置的密码登录。';
        }
    }
    return $translation;
}

/* ---------- 5. 注册成功 → 立即登录 + 跳首页 ---------- */
add_action( 'user_register', 'osr_login_and_redirect', 9999 );
function osr_login_and_redirect( $user_id ) {
    wp_set_current_user( $user_id );
    wp_set_auth_cookie( $user_id, true );
    add_filter( 'registration_redirect', 'osr_redirect_home' );
}
function osr_redirect_home() {
    return home_url();   // 想去后台改成 admin_url()
}