(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // 查看日志详情
        $('.view-context').on('click', function() {
            var context = $(this).data('context');
            var formattedContext = '';
            
            try {
                var parsedContext = JSON.parse(context);
                formattedContext = JSON.stringify(parsedContext, null, 2);
            } catch (e) {
                formattedContext = context;
            }
            
            $('#ncewpv-log-context-content').text(formattedContext);
            $('#ncewpv-log-context-modal').show();
        });
        
        // 关闭模态框
        $('.ncewpv-modal-close, .ncewpv-modal-overlay').on('click', function() {
            $('#ncewpv-log-context-modal').hide();
        });
        
        // ESC键关闭模态框
        $(document).on('keydown', function(e) {
            if (e.keyCode === 27 && $('#ncewpv-log-context-modal').is(':visible')) {
                $('#ncewpv-log-context-modal').hide();
            }
        });
        
        // 清理日志
        $('#ncewpv-clear-logs').on('click', function() {
            if (!confirm(ncewpv_logs.confirm_clear)) {
                return;
            }
            
            var $button = $(this);
            var daysToKeep = $('#ncewpv-clear-days').val();
            
            $button.prop('disabled', true).text('清理中...');
            
            $.ajax({
                url: ncewpv_logs.ajaxurl,
                type: 'POST',
                data: {
                    action: 'ncewpv_clear_logs',
                    days_to_keep: daysToKeep,
                    nonce: ncewpv_logs.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.data.message);
                        location.reload();
                    } else {
                        alert('清理失败: ' + response.data);
                    }
                },
                error: function() {
                    alert('请求失败，请重试');
                },
                complete: function() {
                    $button.prop('disabled', false).text('清理旧日志');
                }
            });
        });
        
    });
    
})(jQuery);