(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // 确认删除操作
        $('a.button-link-delete').on('click', function(e) {
            if (!confirm(ncewpv_orders.confirm_delete)) {
                e.preventDefault();
            }
        });
        
        // 确认退款操作
        $('a.button-secondary').on('click', function(e) {
            if ($(this).text().trim() === '退款' && !confirm(ncewpv_orders.confirm_refund)) {
                e.preventDefault();
            }
        });
        
        // 批量操作确认
        $('select[name="action"], select[name="action2"]').on('change', function() {
            var action = $(this).val();
            if (action === 'delete' && !confirm('确定要删除选中的订单吗？此操作不可恢复。')) {
                $(this).val('-1');
            }
        });
        
        // 订单详情模态框（可以后续扩展）
        $('.ncewpv-order-details').on('click', function(e) {
            e.preventDefault();
            var orderId = $(this).data('order-id');
            // 这里可以添加显示订单详情的逻辑
            alert('订单详情功能开发中...');
        });
        
    });
    
})(jQuery);