(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // PayPal连接测试
        $('#ncewpv-test-connection').on('click', function(e) {
            e.preventDefault();
            
            var $button = $(this);
            var $result = $('#ncewpv-test-result');
            
            $button.prop('disabled', true);
            $result.removeClass('success error').addClass('loading').text('测试中...');
            
            $.ajax({
                url: ajaxurl,
                type: 'POST',
                data: {
                    action: 'ncewpv_test_paypal_connection',
                    nonce: ncewpv_admin.nonce
                },
                success: function(response) {
                    $button.prop('disabled', false);
                    
                    if (response.success) {
                        $result.removeClass('loading error').addClass('success').text('连接成功！');
                    } else {
                        var errorMsg = response.data || '连接失败，请检查配置';
                        $result.removeClass('loading success').addClass('error').text(errorMsg);
                    }
                },
                error: function() {
                    $button.prop('disabled', false);
                    $result.removeClass('loading success').addClass('error').text('请求失败，请重试');
                }
            });
        });
        
        // 环境切换提示
        $('#environment').on('change', function() {
            var environment = $(this).val();
            if (environment === 'live') {
                if (!confirm('警告：切换到生产环境后将进行真实支付交易。请确保您已正确配置生产环境的Client ID和Secret。是否继续？')) {
                    $(this).val('sandbox');
                }
            }
        });
        
        // 费率系数输入验证
        $('#fee_rate').on('change', function() {
            var value = parseFloat($(this).val());
            if (value < 1) {
                alert('费率系数不能小于1');
                $(this).val('1.00');
            }
            if (value > 2) {
                alert('费率系数不能大于2');
                $(this).val('2.00');
            }
        });
        
        // 固定费输入验证
        $('#fixed_fee').on('change', function() {
            var value = parseFloat($(this).val());
            if (value < 0) {
                alert('固定费不能为负数');
                $(this).val('0');
            }
        });
        
    });
    
})(jQuery);